unit Question3_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, Star_U;

type
  TfrmStars = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    cbxStar: TComboBox;
    redDisplay: TRichEdit;
    btnObject: TButton;
    btnDisplay: TButton;
    btnVisibility: TButton;
    imgStar: TImage;
    procedure btnObjectClick(Sender: TObject);
    procedure btnDisplayClick(Sender: TObject);
    procedure btnVisibilityClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmStars: TfrmStars;
  // Provided code
  objStarX: TStar;


implementation
 var
  aNavigationStars: array [1 .. 58] of String = (
    'Alpheratz','Ankaa','Schedar','Diphda','Achernar','Hamal','Acamar',
    'Menkar','Mirfak','Aldebaran','Rigel','Capella','Bellatrix','Elnath',
    'Alnilam','Betelgeuse','Canopus','Sirius','Adhara','Procyon','Pollux',
    'Avior','Suhail','Miaplacidus','Alphard','Regulus','Dubhe','Denebola',
    'Gienah','Acrux','Gacrux','Alioth','Spica','Alkaid','Hadar','Menkent',
    'Rigil Kentaurus','Arcturus','Zubenelgenubi','Kochab','Alphecca',
    'Antares','Atria','Sabik','Shaula','Rasalhague','Eltanin',
    'Kaus Australis','Vega','Nunki','Altair','Peacock','Deneb','Enif',
    'Al Na''ir','Fomalhaut','Markab','Polaris');

{$R *.dfm}

procedure TfrmStars.btnDisplayClick(Sender: TObject);
begin
  redDisplay.Clear;
  redDisplay.Lines.Add(objStarX.toString);
  imgStar.Picture.LoadFromFile(objStarX.getConstellation + '.bmp');
end;

procedure TfrmStars.btnObjectClick(Sender: TObject);
var
sStarName: String;
tFile: textFile;
sLine, sConstellation: String;
rMagnitude : real;
bFoundFile, bFoundArray: Boolean;
A, iDistance : Integer;
begin
  sStarName := cbxStar.Items[cbxStar.ItemIndex];
  AssignFile(tFile, 'StarData.txt');
  Reset(tFile);
  bFoundFile := false;
  While NOT Eof(tFile) AND NOT bFoundFile do
  begin
    Readln(tFile, sLine);
    if Trim(sStarName) = Trim(sLine) then
    begin
       Readln(tFile, sLine);
       rMagnitude := StrToFloat(sLine);
       Readln(tFile, sLine);
       iDistance := StrToInt(sLine);
       Readln(tFile, sConstellation);
       objStarX := TStar.Create(sStarName, rMagnitude, iDistance, sConstellation);
       bFoundArray := false;
       for A := 1 to Length(aNavigationStars) do
         If pos(aNavigationStars[A], objStarX.getName) > 0 then
            bFoundArray := true;
         objStarX.setNavigationalStatus(bFoundArray);
         bFoundFile := true;
    end;
    Readln(tFile, sLine);
  end;
  if NOT bFoundFile then
  begin
     ShowMessage('The star was not found in the file.');
  end;
CloseFile(tFile);

end;

procedure TfrmStars.btnVisibilityClick(Sender: TObject);
begin
  redDisplay.Clear;
  redDisplay.Paragraph.TabCount := 1;
  redDisplay.Paragraph.Tab[0] := 50;
  redDisplay.Lines.Add('Star:' + #9 +objStarX.getName);
  redDisplay.Lines.Add('Visibility: ' +#9 + objStarX.determineVisibilty);
end;

end.
